/** @file wxw_input.h

	Skelton for retropc emulator
	wxWidgets edition

	@author Sasaji
	@date   2012.02.21

	@brief [ wxw input ]

*/

#ifndef WXW_INPUT_H
#define WXW_INPUT_H

#include "../../emu.h"
#include "../../vm/vm.h"
#include "../../keycode.h"

#if defined(__WXMSW__)

typedef struct st_nc2kc {
	short nc;
	short kc;
} nc2kc_t;

/// mapping from VK_* virtual key to original keycode
const uint8_t vkkey2keycode[256] = {
	/* 0x00 - 0x0f */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	KEYCODE_BACKSPACE,
	KEYCODE_TAB,
	0,
	0,
	KEYCODE_CLEAR,
	KEYCODE_RETURN,
	0,
	0,
	/* 0x10 - 0x1f */
	KEYCODE_SHIFT,
	KEYCODE_CONTROL,
	KEYCODE_ALT,
	KEYCODE_PAUSE,
	KEYCODE_CAPSLOCK,
	KEYCODE_KATAHIRA,
	0,
	0,
	0,
	KEYCODE_GRAVE,
	0,
	KEYCODE_ESCAPE,
	KEYCODE_HENKAN,
	KEYCODE_MUHENKAN,
	0,
	0,
	/* 0x20 - 0x2f */
	KEYCODE_SPACE,
	KEYCODE_PAGEUP,
	KEYCODE_PAGEDOWN,
	KEYCODE_END,
	KEYCODE_HOME,
	KEYCODE_LEFT,
	KEYCODE_UP,
	KEYCODE_RIGHT,
	KEYCODE_DOWN,
	KEYCODE_SELECT,
	KEYCODE_PRINT,
	0,
	0,
	KEYCODE_INSERT,
	KEYCODE_DELETE,
	KEYCODE_HELP,
	/* 0x30 - 0x3f */
	KEYCODE_0,
	KEYCODE_1,
	KEYCODE_2,
	KEYCODE_3,
	KEYCODE_4,
	KEYCODE_5,
	KEYCODE_6,
	KEYCODE_7,
	KEYCODE_8,
	KEYCODE_9,
	0,
	0,
	0,
	0,
	0,
	0,
	/* 0x40 - 0x4f */
	0,
	KEYCODE_A,
	KEYCODE_B,
	KEYCODE_C,
	KEYCODE_D,
	KEYCODE_E,
	KEYCODE_F,
	KEYCODE_G,
	KEYCODE_H,
	KEYCODE_I,
	KEYCODE_J,
	KEYCODE_K,
	KEYCODE_L,
	KEYCODE_M,
	KEYCODE_N,
	KEYCODE_O,
	/* 0x50 - 0x5f */
	KEYCODE_P,
	KEYCODE_Q,
	KEYCODE_R,
	KEYCODE_S,
	KEYCODE_T,
	KEYCODE_U,
	KEYCODE_V,
	KEYCODE_W,
	KEYCODE_X,
	KEYCODE_Y,
	KEYCODE_Z,
	KEYCODE_LSUPER,
	KEYCODE_RSUPER,
	KEYCODE_MENU,
	0,
	0, // KEYCODE_SLEEP
	/* 0x60 - 0x6f */
	KEYCODE_KP_0,
	KEYCODE_KP_1,
	KEYCODE_KP_2,
	KEYCODE_KP_3,
	KEYCODE_KP_4,
	KEYCODE_KP_5,
	KEYCODE_KP_6,
	KEYCODE_KP_7,
	KEYCODE_KP_8,
	KEYCODE_KP_9,
	KEYCODE_KP_MULTIPLY,
	KEYCODE_KP_PLUS,
	0,
	KEYCODE_KP_MINUS,
	KEYCODE_KP_PERIOD,
	KEYCODE_KP_DIVIDE,
	/* 0x70 - 0x7f */
	KEYCODE_F1,
	KEYCODE_F2,
	KEYCODE_F3,
	KEYCODE_F4,
	KEYCODE_F5,
	KEYCODE_F6,
	KEYCODE_F7,
	KEYCODE_F8,
	KEYCODE_F9,
	KEYCODE_F10, 
	KEYCODE_F11,
	KEYCODE_F12,
	KEYCODE_F13,
	KEYCODE_F14,
	KEYCODE_F15,
	KEYCODE_F16,
	/* 0x80 - 0x8f */
	KEYCODE_F17,
	KEYCODE_F18,
	KEYCODE_F19,
	KEYCODE_F20,
	KEYCODE_F21,
	KEYCODE_F22,
	KEYCODE_WORLD_0,
	KEYCODE_WORLD_1,
	KEYCODE_WORLD_2,
	KEYCODE_WORLD_3,
	KEYCODE_WORLD_4,
	KEYCODE_WORLD_5,
	KEYCODE_WORLD_6,
	KEYCODE_WORLD_7,
	KEYCODE_WORLD_8,
	KEYCODE_WORLD_9,
	/* 0x90 - 0x9f */
	KEYCODE_NUMLOCK,
	KEYCODE_SCROLLLOCK,
	KEYCODE_KP_EQUALS,
	KEYCODE_JISHO,
	KEYCODE_MASSHOU,
	KEYCODE_TOUROKU,
	KEYCODE_LOYAYUBI,
	KEYCODE_ROYAYUBI,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	/* 0xa0 - 0xaf */
	KEYCODE_LSHIFT,
	KEYCODE_RSHIFT,
	KEYCODE_LCTRL,
	KEYCODE_RCTRL,
	KEYCODE_LALT,
	KEYCODE_RALT,
	KEYCODE_BROWSER_BACK,
	KEYCODE_BROWSER_FORWARD,
	KEYCODE_BROWSER_REFRESH,
	KEYCODE_BROWSER_STOP,
	KEYCODE_BROWSER_SEARCH,
	KEYCODE_BROWSER_FAVOR, 
	KEYCODE_BROWSER_HOME, 
	KEYCODE_VOLUME_MUTE, 
	KEYCODE_VOLUME_DOWN, 
	KEYCODE_VOLUME_UP,
	/* 0xb0 - 0xbf */
	0,
	0,
	0,
	0, 
	0,
	0, 
	0, 
	0,
	0,
	0, 
	KEYCODE_COLON,
	KEYCODE_SEMICOLON,
	KEYCODE_COMMA,
	KEYCODE_MINUS, 
	KEYCODE_PERIOD, 
	KEYCODE_SLASH,
	/* 0xc0 - 0xcf */
	KEYCODE_AT,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0, 
	0,
	0,
	0, 
	0,
	0,
	0,
	0,
	/* 0xd0 - 0xdf */
	0,
	0,
	0, 
	0,
	0,
	0, 
	0, 
	0,
	0,
	0,
	0,
	KEYCODE_LBRACKET,
	KEYCODE_BACKSLASH,
	KEYCODE_RBRACKET,
	KEYCODE_CARET,
	0,
	/* 0xe0 - 0xef */
	0,
	0,
	KEYCODE_UNDERSCORE,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0, 
	0, 
	0,
	0,
	0,
	0,
	/* 0xf0 - 0xff */
	KEYCODE_CAPSLOCK,
	KEYCODE_MUHENKAN,
	KEYCODE_KATAHIRA,
	KEYCODE_HENKAN,
	KEYCODE_HENKAN,
	0, 
	0,
	0,
	0,
	0,
	0,
	0,
	0, 
	0, 
	0,
	0
};

static const uint8_t scancode2keycode47[16] = {
	/* 0x47 - 0x56 */
	KEYCODE_KP_7,
	KEYCODE_KP_8,
	KEYCODE_KP_9,
	0,
	KEYCODE_KP_4,
	KEYCODE_KP_5,
	KEYCODE_KP_6,
	0,
	KEYCODE_KP_1,
	KEYCODE_KP_2,
	KEYCODE_KP_3,
	KEYCODE_KP_0,
	KEYCODE_KP_PERIOD,
	0,
	0,
	0
};

static const uint8_t scancode2keycode70[16] = {
	/* 0x70 - 0x7f */
	KEYCODE_KATAHIRA,	// Katakana / Hiragana (JP)
	0,
	0,
	KEYCODE_UNDERSCORE,	// _
	0,
	0,
	0,
	0,
	0,
	KEYCODE_HENKAN,		// Henkan (JP)
	0,
	KEYCODE_MUHENKAN,	// Muhenkan (JP)
	0,
	KEYCODE_BACKSLASH,	// Yen
	0,
	0
};

#elif defined(__WXOSX__)

const uint8_t scancode2keycode[128] = {
	/* 0x00 - 0x0f */
	KEYCODE_A,			// A
	KEYCODE_S,			// S
	KEYCODE_D,			// D
	KEYCODE_F,			// F
	KEYCODE_H,			// H
	KEYCODE_G,			// G
	KEYCODE_Z,			// Z
	KEYCODE_X,			// X
	KEYCODE_C,			// C
	KEYCODE_V,			// V
	0,
	KEYCODE_B,			// B
	KEYCODE_Q,			// Q
	KEYCODE_W,			// W
	KEYCODE_E,			// E
	KEYCODE_R,			// R
	/* 0x10 - 0x1f */
	KEYCODE_Y,			// Y
	KEYCODE_T,			// T
	KEYCODE_1,			// 1 !
	KEYCODE_2,			// 2 "
	KEYCODE_3,			// 3 #
	KEYCODE_4,			// 4 $
	KEYCODE_6,			// 6 &
	KEYCODE_5,			// 5 %
	KEYCODE_CARET,		// ~ ^ (JP) + = (US)
	KEYCODE_9,			// 9 )
	KEYCODE_7,			// 7 '
	KEYCODE_MINUS,		// - = (JP) - _ (US)
	KEYCODE_8,			// 8 (
	KEYCODE_0,			// 0
	KEYCODE_LBRACKET,	// [ { (JP) ] } (US)
	KEYCODE_O,			// O
	/* 0x20 - 0x2f */
	KEYCODE_U,			// U
	KEYCODE_AT,			// @ ` (JP) [ { (US)
	KEYCODE_I,			// I
	KEYCODE_P,			// P
	KEYCODE_RETURN,		// Enter
	KEYCODE_L,			// L
	KEYCODE_J,			// J
	KEYCODE_COLON,		// : * (JP) " ' (US)
	KEYCODE_K,			// K
	KEYCODE_SEMICOLON,	// ; + (JP) : ; (US)
	KEYCODE_RBRACKET,	// ] } (JP) | \ (US)
	KEYCODE_COMMA,		// , <
	KEYCODE_SLASH,		// / ?
	KEYCODE_N,			// N
	KEYCODE_M,			// M
	KEYCODE_PERIOD,		// . >
	/* 0x30 - 0x3f */
	KEYCODE_TAB,		// Tab
	KEYCODE_SPACE,		// Space
	KEYCODE_GRAVE,		// Kanji `
	KEYCODE_BACKSPACE,	// BackSpace
	0, //KEYCODE_IB_ENTER,		// iBook Enter
	KEYCODE_ESCAPE,		// ESC
	KEYCODE_RGUI,		// Right command
	KEYCODE_LGUI,		// Left command
	KEYCODE_LSHIFT,		// Left Shift
	KEYCODE_CAPSLOCK,	// CapsLock
	KEYCODE_LALT,		// Left Alt
	KEYCODE_LCTRL,		// Left Ctrl
	KEYCODE_RSHIFT,		// Right Shift
	KEYCODE_RALT,		// Right Alt
	KEYCODE_RCTRL,		// Right Ctrl
	KEYCODE_FUNCTION,	// fn
	/* 0x40 - 0x4f */
	KEYCODE_F17,		// F17
	KEYCODE_KP_PERIOD,	// num .
	0,
	KEYCODE_KP_MULTIPLY,// num *
	0,
	KEYCODE_KP_PLUS,	// num +
	0,
	KEYCODE_NUMLOCK,	// clear
	0,
	0,
	0,
	KEYCODE_KP_DIVIDE,	// num /
	KEYCODE_KP_ENTER,	// num enter
	KEYCODE_KP_MINUS,	// num -
	0,
	KEYCODE_F18,		// F18
	/* 0x50 - 0x5f */
	KEYCODE_F19,		// F19
	KEYCODE_KP_EQUALS,	// num equal
	KEYCODE_KP_0,		// num 0
	KEYCODE_KP_1,		// num 1
	KEYCODE_KP_2,		// num 2
	KEYCODE_KP_3,		// num 3
	KEYCODE_KP_4,		// num 4
	KEYCODE_KP_5,		// num 5
	KEYCODE_KP_6,		// num 6
	KEYCODE_KP_7,		// num 7
	0,
	KEYCODE_KP_8,		// num 8
	KEYCODE_KP_9,		// num 9
	KEYCODE_BACKSLASH,	// yen(backslash)
	KEYCODE_UNDERSCORE,	// _
	0,
	/* 0x60 - 0x6f */
	KEYCODE_F5,			// F5
	KEYCODE_F6,			// F6
	KEYCODE_F7,			// F7
	KEYCODE_F3,			// F3
	KEYCODE_F8,			// F8
	KEYCODE_F9,			// F9
	KEYCODE_EISU,		// eisu
	KEYCODE_F11,		// F11
	KEYCODE_KANA,		// kana
	KEYCODE_F13,		// F13
	KEYCODE_F16,		// F16
	KEYCODE_F14,		// F14
	0,
	KEYCODE_F10,		// F10
	KEYCODE_MENU,		// menu
	KEYCODE_F12,		// F12
	/* 0x70 - 0x7f */
	0,
	KEYCODE_F15,		// F15
	KEYCODE_INSERT,		// insert
	KEYCODE_HOME,		// home
	KEYCODE_PAGEUP,		// page up
	KEYCODE_DELETE,		// delete x
	KEYCODE_F4,			// F4
	KEYCODE_END,		// end
	KEYCODE_F2,			// F2
	KEYCODE_PAGEDOWN,	// page down
	KEYCODE_F1,			// F1
	KEYCODE_LEFT,		// left
	KEYCODE_RIGHT,		// right
	KEYCODE_DOWN,		// down
	KEYCODE_UP,			// up
	KEYCODE_POWER		// power

//	KEYCODE_PAUSE,		// Pause / Break
//	KEYCODE_SCROLLLOCK,	// Scroll Lock
//	KEYCODE_KATAHIRA,	// Katakana / Hiragana (JP)
//	KEYCODE_UNDERSCORE,	// _
};

typedef struct st_ks2kc {
	short ks;
	short kc;
} ks2kc_t;

const ks2kc_t keysym2keycode[] = {
	{ 97,  KEYCODE_A },
	{ 301, KEYCODE_CAPSLOCK },
	{ 303, KEYCODE_RSHIFT },
	{ 304, KEYCODE_LSHIFT },
	{ 305, KEYCODE_RCTRL },
	{ 306, KEYCODE_LCTRL },
	{ 307, KEYCODE_RALT },
	{ 308, KEYCODE_LALT },
	{ 309, KEYCODE_RGUI },
	{ 310, KEYCODE_LGUI },
	{ -1, -1 }
};

#elif defined(__WXGTK__)

/// mapping from gdk keysym to original keycode
const uint8_t gdkkey2keycode[256] = {
	/* 0x00 - 0x0f */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	/* 0x10 - 0x1f */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	/* 0x20 - 0x2f */
	KEYCODE_SPACE,
	KEYCODE_1,
	KEYCODE_2,
	KEYCODE_3,
	KEYCODE_4,
	KEYCODE_5,
	KEYCODE_6,
	KEYCODE_7,
	KEYCODE_8,
	KEYCODE_9,
	KEYCODE_COLON, //KEYCODE_AT,
	KEYCODE_SEMICOLON, //KEYCODE_PLUS,
	KEYCODE_COMMA,
	KEYCODE_MINUS,
	KEYCODE_PERIOD,
	KEYCODE_SLASH,
	/* 0x30 - 0x3f */
	KEYCODE_0,
	KEYCODE_1,
	KEYCODE_2,
	KEYCODE_3,
	KEYCODE_4,
	KEYCODE_5,
	KEYCODE_6,
	KEYCODE_7,
	KEYCODE_8,
	KEYCODE_9,
	KEYCODE_COLON,
	KEYCODE_SEMICOLON,
	KEYCODE_COMMA, //KEYCODE_LESS
	KEYCODE_MINUS, //KEYCODE_EQUAL
	KEYCODE_PERIOD, //KEYCODE_GREATER
	KEYCODE_SLASH, //KEYCODE_QUESTION
	/* 0x40 - 0x4f */
	KEYCODE_AT,
	KEYCODE_A,
	KEYCODE_B,
	KEYCODE_C,
	KEYCODE_D,
	KEYCODE_E,
	KEYCODE_F,
	KEYCODE_G,
	KEYCODE_H,
	KEYCODE_I,
	KEYCODE_J,
	KEYCODE_K,
	KEYCODE_L,
	KEYCODE_M,
	KEYCODE_N,
	KEYCODE_O,
	/* 0x50 - 0x5f */
	KEYCODE_P,
	KEYCODE_Q,
	KEYCODE_R,
	KEYCODE_S,
	KEYCODE_T,
	KEYCODE_U,
	KEYCODE_V,
	KEYCODE_W,
	KEYCODE_X,
	KEYCODE_Y,
	KEYCODE_Z,
	KEYCODE_LBRACKET,
	KEYCODE_BACKSLASH,
	KEYCODE_RBRACKET,
	KEYCODE_CARET,
	KEYCODE_UNDERSCORE,
	/* 0x60 - 0x6f */
	KEYCODE_AT,
	KEYCODE_A,
	KEYCODE_B,
	KEYCODE_C,
	KEYCODE_D,
	KEYCODE_E,
	KEYCODE_F,
	KEYCODE_G,
	KEYCODE_H,
	KEYCODE_I,
	KEYCODE_J,
	KEYCODE_K,
	KEYCODE_L,
	KEYCODE_M,
	KEYCODE_N,
	KEYCODE_O,
	/* 0x70 - 0x7f */
	KEYCODE_P,
	KEYCODE_Q,
	KEYCODE_R,
	KEYCODE_S,
	KEYCODE_T,
	KEYCODE_U,
	KEYCODE_V,
	KEYCODE_W,
	KEYCODE_X,
	KEYCODE_Y,
	KEYCODE_Z,
	KEYCODE_LBRACKET,
	KEYCODE_BACKSLASH,
	KEYCODE_RBRACKET,
	KEYCODE_CARET,
	KEYCODE_UNDERSCORE,
	/* 0x80 - 0x8f */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	/* 0x90 - 0x9f */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	/* 0xa0 - 0xaf */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	/* 0xb0 - 0xbf */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	/* 0xc0 - 0xcf */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	/* 0xd0 - 0xdf */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	/* 0xe0 - 0xef */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	/* 0xf0 - 0xff */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0
};

const uint8_t gdkkey2keycodeFF[256] = {
	/* 0x00 - 0x0f */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	KEYCODE_BACKSPACE,
	KEYCODE_TAB,
	0,
	KEYCODE_CLEAR,
	0,
	KEYCODE_RETURN,
	0,
	0,
	/* 0x10 - 0x1f */
	0,
	0,
	0,
	KEYCODE_PAUSE,
	KEYCODE_SCROLLLOCK,
	KEYCODE_SYSREQ,
	0,
	0,
	0,
	KEYCODE_GRAVE,
	0,
	KEYCODE_ESCAPE,
	0,
	0,
	0,
	0,
	/* 0x20 - 0x2f */
	0,
	KEYCODE_GRAVE,
	KEYCODE_MUHENKAN,
	KEYCODE_HENKAN,
	0, //KEYCODE_ROMAJI,
	KEYCODE_KATAHIRA,
	KEYCODE_KATAHIRA,
	KEYCODE_KATAHIRA,
	KEYCODE_GRAVE,
	KEYCODE_GRAVE,
	KEYCODE_GRAVE,
	0,
	0,
	0,
	0,
	0,
	/* 0x30 - 0x3f */
	KEYCODE_CAPSLOCK,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	/* 0x40 - 0x4f */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	/* 0x50 - 0x5f */
	KEYCODE_HOME,
	KEYCODE_LEFT,
	KEYCODE_UP,
	KEYCODE_RIGHT,
	KEYCODE_DOWN,
	KEYCODE_PAGEUP,
	KEYCODE_PAGEDOWN,
	KEYCODE_END,
	0, //KEYCODE_BGEIN,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	/* 0x60 - 0x6f */
	KEYCODE_SELECT,
	KEYCODE_PRINT,
	0, //KEYCODE_EXECUTE,
	KEYCODE_INSERT,
	KEYCODE_UNDO,
	0, //KEYCODE_REDO,
	KEYCODE_MENU,
	0, //KEYCODE_FIND,
	0, //KEYCODE_CANCEL,
	KEYCODE_HELP,
	0, //KEYCODE_BREAK,
	0,
	0,
	0,
	0,
	0,
	/* 0x70 - 0x7f */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	KEYCODE_NUMLOCK,
	/* 0x80 - 0x8f */
	0, //KEYCODE_KP_SPACE,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0, //KEYCODE_KP_TAB,
	0,
	0,
	0,
	KEYCODE_KP_ENTER,
	0,
	0,
	/* 0x90 - 0x9f */
	0,
	0, //KEYCODE_KP_F1,
	0, //KEYCODE_KP_F2,
	0, //KEYCODE_KP_F3,
	0, //KEYCODE_KP_F4,
	KEYCODE_KP_7, //KEYCODE_KP_HOME,
	KEYCODE_KP_4, //KEYCODE_KP_LEFT,
	KEYCODE_KP_8, //KEYCODE_KP_UP,
	KEYCODE_KP_6, //KEYCODE_KP_RIGHT,
	KEYCODE_KP_2, //KEYCODE_KP_DOWN,
	KEYCODE_KP_9, //KEYCODE_KP_PAGEUP,
	KEYCODE_KP_3, //KEYCODE_KP_PAGEDOWN,
	KEYCODE_KP_1, //KEYCODE_KP_END,
	0, //KEYCODE_KP_BEGIN,
	KEYCODE_KP_0, //KEYCODE_KP_INSERT,
	KEYCODE_KP_PERIOD, //KEYCODE_KP_DELETE,
	/* 0xa0 - 0xaf */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	KEYCODE_KP_MULTIPLY,
	KEYCODE_KP_PLUS,
	KEYCODE_KP_DIVIDE,
	KEYCODE_KP_MINUS,
	KEYCODE_KP_PERIOD,
	KEYCODE_KP_DIVIDE,
	/* 0xb0 - 0xbf */
	KEYCODE_KP_0,
	KEYCODE_KP_1,
	KEYCODE_KP_2,
	KEYCODE_KP_3,
	KEYCODE_KP_4,
	KEYCODE_KP_5,
	KEYCODE_KP_6,
	KEYCODE_KP_7,
	KEYCODE_KP_8,
	KEYCODE_KP_9,
	0,
	0,
	0,
	0,
	KEYCODE_F1,
	KEYCODE_F2,
	/* 0xc0 - 0xcf */
	KEYCODE_F3,
	KEYCODE_F4,
	KEYCODE_F5,
	KEYCODE_F6,
	KEYCODE_F7,
	KEYCODE_F8,
	KEYCODE_F9,
	KEYCODE_F10,
	KEYCODE_F11,
	KEYCODE_F12,
	KEYCODE_F13,
	KEYCODE_F14,
	KEYCODE_F15,
	KEYCODE_F16,
	KEYCODE_F17,
	KEYCODE_F18,
	/* 0xd0 - 0xdf */
	KEYCODE_F19,
	KEYCODE_F20,
	KEYCODE_F21,
	KEYCODE_F22,
	0, //KEYCODE_F23,
	0, //KEYCODE_F24,
	0, //KEYCODE_F25,
	0, //KEYCODE_F26,
	0, //KEYCODE_F27,
	0, //KEYCODE_F28,
	0, //KEYCODE_F29,
	0, //KEYCODE_F30,
	0,
	0,
	0,
	0,
	/* 0xe0 - 0xef */
	0,
	KEYCODE_LSHIFT,
	KEYCODE_RSHIFT,
	KEYCODE_LCTRL,
	KEYCODE_RCTRL,
	KEYCODE_CAPSLOCK,
	0, //KEYCODE_SHIFTLOCK,
	KEYCODE_LGUI,
	KEYCODE_RGUI,
	KEYCODE_LALT,
	KEYCODE_RALT,
	KEYCODE_LSUPER,
	KEYCODE_RSUPER,
	0,
	0,
	0,
	/* 0xf0 - 0xff */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0
};

#endif

#endif /* WXW_INPUT_H */
